﻿

CREATE PROCEDURE [PanelMgmt].[usp_PMUpdateMasterLabIndexFromLOINC] 
AS
--=================================================================================
--Requestor				: Jianji Yang
--Author                : Jerry Kohler (Original script by Steve Schreiner)
--Object/SP Name		: [PanelMgmt].[usp_PMUpdateMasterLabIndexfromLOINC]
--SERVER				: SERVER      
--Data Base				: NWIC_PanelMgmt
--Schema				: PanelMgmt
--Report				: None Yet
--Folder				:
--Report Loc            : 
--Job                   : None
--Job Loc               : None
--Note                  : 
--Date Created          : 12-28-2015
--Last Changed          :   
--Last Changed By		: 
--Reason For Change		:                              
--Purpose               : Update Panel Management Master Lab Index table 
--                        with lab test that have valid LOINC codes.  This is done
--                        through the BISL's incremental update method in the first
--                        section.  This is done to decrease the processing time
--                        and conserve server resources.
--=================================================================================
SET NOCOUNT on

BEGIN
    /* 
    Locate and load the outstanding Chem.LabChem batches since the
    last execution rather than processing the entire Chem.LabChem view.
    */

	--declare batch variables and cursor
	DECLARE @ETLBatchID   AS INT, @ExtractBatchID AS INT;
	DECLARE @DWViewSchema AS VARCHAR(50) = 'Chem';
	DECLARE @DWViewName   AS VARCHAR(50) = 'LabChem';


    DECLARE BatchCursor CURSOR STATIC FOR
	--get batch ids
	   SELECT EX.ETLBatchID, EX.ExtractBatchID
	   FROM SPV.EB.ExtractBatch AS EX
	   INNER JOIN Dflt.ExtractBatchLog AS EL
               ON EX.DWViewSchema = EL.DWViewSchema AND EX.DWViewName = EL.DWViewName
	   WHERE EX.DWViewSchema = @DWViewSchema
         AND EX.DWViewName   = @DWViewName
         AND EX.ExtractBatchID > EL.LastExtractBatchID
	   ORDER BY EX.ExtractBatchID;

	OPEN BatchCursor;
	FETCH NEXT FROM BatchCursor INTO @ETLBatchID, @ExtractBatchID;

	WHILE @@FETCH_STATUS = 0
	BEGIN

        IF (SELECT OBJECT_ID('tempdb..#LabChemPrep')) IS NOT NULL
        DROP TABLE #LabChemPrep

		-- the lab results load table has duplicate records, which the
        -- MERGE statement will not tolerate.  Try and get the latest
        -- record for each LabChemTestSID in the batch by sorting on
        -- specimen date time descending within that LabChemTestSID
		SELECT [Sta3n]
              ,[LabChemTestSID]
              ,[LOINCSID]
              ,[LabChemSpecimenDateTime]
              ,[LabChemCompleteDateTime]
              ,[ETLBatchID]
              ,[OpCode]
              ,[VistaCreateDate]
              ,[VistaEditDate]
              ,row_number() over (Partition by LabChemTestSID
                                      order by LabChemTestSID, LabChemSpecimenDateTime DESC) AS RN
        INTO #LabChemPrep
		FROM SPV.Chem.LabChem
		WHERE ETLBatchID = @ETLBatchID            

		-- merge data into production(destination) table
		MERGE 
			ETL.ProdLabChem AS D
		USING
			(
				SELECT [Sta3n]
                      ,[LabChemTestSID]
                      ,[LOINCSID]
                      ,[LabChemSpecimenDateTime]
                      ,[LabChemCompleteDateTime]
                      ,[ETLBatchID]
                      ,[OpCode]
                      ,[VistaCreateDate]
                      ,[VistaEditDate]
                      ,RN
				FROM #LabChemPrep
				WHERE ETLBatchID = @ETLBatchID
                  AND RN = 1 -- the latest record for a given LabChemTestSID
			) AS M
		ON
			D.LabChemTestSID = M.LabChemTestSID
		WHEN NOT MATCHED THEN
			INSERT
				(
					   [Sta3n]
                      ,[LabChemTestSID]
                      ,[LOINCSID]
                      ,[LabChemSpecimenDateTime]
                      ,[LabChemCompleteDateTime]
                      ,[ETLBatchID]
                      ,[OpCode]
                      ,[VistaCreateDate]
                      ,[VistaEditDate]
				)
			VALUES
				(
                     M.[Sta3n]
                    ,M.[LabChemTestSID]
                    ,M.[LOINCSID]
                    ,M.[LabChemSpecimenDateTime]
                    ,M.[LabChemCompleteDateTime]
                    ,M.[ETLBatchID]
                    ,M.[OpCode]
                    ,M.[VistaCreateDate]
                    ,M.[VistaEditDate]

				)
		WHEN MATCHED THEN
			UPDATE SET
                       [Sta3n]                   = M.[Sta3n]
					  ,[LabChemTestSID]          = M.[LabChemTestSID]
                      ,[LOINCSID]                = M.[LOINCSID]
                      ,[LabChemSpecimenDateTime] = M.[LabChemSpecimenDateTime]
                      ,[LabChemCompleteDateTime] = M.[LabChemCompleteDateTime]
                      ,[ETLBatchID]              = M.[ETLBatchID]
                      ,[OpCode]                  = M.[OpCode]
                      ,[VistaCreateDate]         = M.[VistaCreateDate]
                      ,[VistaEditDate]           = M.[VistaEditDate]
		;

		-- after merging batch then update the ExtractBatchLog table
		UPDATE Dflt.ExtractBatchLog
		   SET LastExtractBatchID = @ExtractBatchID, LastExtractDateTime = GETDATE()
         WHERE DWViewSchema = @DWViewSchema
           AND DWViewName   = @DWViewName;

		-- grab the next batch for processing
		FETCH NEXT FROM BatchCursor INTO @ETLBatchID, @ExtractBatchID;
	END

	-- close and deallocate the cursor once all batches for a given table have been processed
	CLOSE BatchCursor;
	DEALLOCATE BatchCursor;

--
--
--
--  Using the incrementally updated ETL.ProdLabChem rather than the full
--  CDWWork.Dim.Labchem view, insert new lab tests into [PanelMgmt].[PMMasterLabIndex] 
--
--
--
   -- all LOINC SIDS for all stations defined in PMMasterCohortSite
   IF (SELECT OBJECT_ID('tempdb..#TempLOINCSID')) IS NOT NULL
   DROP TABLE #TempLOINCSID

   select li.LOINCSID
          ,li.Sta3n
          ,lc.LOINC
          ,lc.TestGroup
          ,lc.ResultForTestNumeric
          ,dateadd(yy,lc.YearSearchCriteria,getdate()) as YearSearchDate
   into	#TempLOINCSID
   from	[PanelMgmt].[PMMasterCohortLabTestGroupsLOINCCodes] as lc
   inner join [CDWWork].[Dim].[LOINC] as li on lc.LOINC = li.LOINC
   inner join [PanelMgmt].[PMMasterCohortSite] as cs on li.Sta3n = cs.Sta3n;


   -- based on LOINC codes, are there any new lab tests we do NOT
   -- already have in PMMasterLabIndex?
   IF (SELECT OBJECT_ID('tempdb..#InsertTheseRecords')) IS NOT NULL
   DROP TABLE #InsertTheseRecords

   select distinct li.LabChemTestSID
   				  ,li.Sta3n
   				  ,li.LabChemTestName
   				  ,tl.ResultForTestNumeric
   				  ,getdate() as DateExtracted
   				  ,tl.TestGroup
   				  ,tl.LOINC
   				  ,NULL as WorkLoadCode
   into         #InsertTheseRecords
   from			[ETL].ProdLabChem lc
   inner join	[CDWWork].[Dim].[LabChemTest] as li on lc.LabChemTestSID = li.LabChemTestSID
   inner join   #TempLOINCSID tl on lc.Sta3n = li.Sta3n AND lc.LabChemCompleteDateTime > tl.YearSearchDate
   where        lc.LOINCSID = tl.LOINCSID
     and        not exists (select ni.LabChemTestSID
   				              from [PanelMgmt].[PMMasterLabIndex] as ni
   						     where li.LabChemTestSID = ni.LabChemTestSID
   							   and li.Sta3n = ni.Sta3n);

   Insert into [PanelMgmt].[PMMasterLabIndex]
   (
      LabChemTestSID,
      Sta3n,
      LabChemTestName,
      ResultForTestNumeric,
      DateExtracted,
      TestGroup,
      LOINC,
      WorkLoadCode
   )
   Select LabChemTestSID,
          Sta3n,
          LabChemTestName,
          ResultForTestNumeric,
          DateExtracted,
          TestGroup,
          LOINC,
          WorkLoadCode
    From #InsertTheseRecords
   
   Drop table #InsertTheseRecords
--select top 1000 * from #InsertTheseRecords
--select * from #InsertTheseRecords where LabChemTestSID in (select LabChemTestSID from [PanelMgmt].[PMMasterLabIndex])
--select distinct dateextracted from #InsertTheseRecords
--select count(*) from #InsertTheseRecords
--select a.*, b.* from #InsertTheseRecords a join cdwwork.dim.labchemtest b on b.LabChemTestSID = a.LabChemTestSID
--select a.* from #InsertTheseRecords a join cdwwork.dim.labchemtest b on b.LabChemTestSID = a.LabChemTestSID where b.Sta3n != a.Sta3n

   UPDATE [PanelMgmt].[PMMasterCohortLabTestGroupsLOINCCodes]
      set LastUpdate = cast(getdate() as date);

END



